#include <iostream>
#include <map>

struct AxisCount { int even = 0; int odd = 0; };

int main() {
    int count;
    std::cin >> count;
    std::map<long, int> hashmap1;
    std::map<long, int> hashmap2;
    std::map<long, AxisCount> hashmapX;
    std::map<long, AxisCount> hashmapY;

    for (int i = 0; i < count; i++) {
        int x, y;
        std::cin >> x >> y;
        hashmap1[x - y]++;
        hashmap2[x + y]++;
        if (y % 2) hashmapX[x].odd++;
        else hashmapX[x].even++;
        if (x % 2) hashmapY[y].odd++;
        else hashmapY[y].even++;
    }

    int greetings = 0;

    for (std::map<long, int>::iterator iterator = hashmap1.begin(); iterator != hashmap1.end(); iterator++)
        greetings += iterator->second * (iterator->second - 1);
    for (std::map<long, int>::iterator iterator = hashmap2.begin(); iterator != hashmap2.end(); iterator++)
        greetings += iterator->second * (iterator->second - 1);
    for (std::map<long, AxisCount>::iterator iterator = hashmapX.begin(); iterator != hashmapX.end(); iterator++)
        greetings += (iterator->second.even * (iterator->second.even - 1) + iterator->second.odd * (iterator->second.odd - 1)) / 2;
    for (std::map<long, AxisCount>::iterator iterator = hashmapY.begin(); iterator != hashmapY.end(); iterator++)
        greetings += (iterator->second.even * (iterator->second.even - 1) + iterator->second.odd * (iterator->second.odd - 1)) / 2;

    std::cout << greetings;
}